from fastapi import APIRouter
from app.api.v1.endpoints import auth, clubs, products, orders, work_orders, baskets, children

router = APIRouter()

# register endpoints
router.include_router(auth.router, prefix="/auth", tags=["auth"])
router.include_router(clubs.router, prefix="/clubs", tags=["clubs"])
router.include_router(products.router, prefix="/products", tags=["products"])
router.include_router(orders.router, prefix="/orders", tags=["orders"])
router.include_router(work_orders.router, prefix="/work-orders", tags=["work-orders"])
router.include_router(baskets.router, prefix="/baskets", tags=["baskets"])
router.include_router(children.router, prefix="/children", tags=["children"])
