from pydantic import BaseModel
from typing import Optional


class ClubBase(BaseModel):
    name: str
    city: Optional[str] = None


class ClubCreate(ClubBase):
    admin_id: Optional[int] = None


class ClubUpdate(BaseModel):
    name: Optional[str] = None
    city: Optional[str] = None
    admin_id: Optional[int] = None


class ClubRead(ClubBase):
    id: int
    admin_id: Optional[int] = None
    trainer_name: Optional[str] = None
    trainer_email: Optional[str] = None

    class Config:
        from_attributes = True
