from pydantic import BaseModel
from typing import Optional
from datetime import datetime


class WorkOrderBase(BaseModel):
    notes: Optional[str] = None


class WorkOrderCreate(WorkOrderBase):
    order_ids: str  # Comma-separated list of order IDs (e.g., "1,2,3,4,5,6")
    club_id: int
    model: Optional[str] = None
    due_date: Optional[datetime] = None


class WorkOrderRead(WorkOrderBase):
    id: int
    work_order_number: str
    order_ids: str
    club_id: int
    created_by_id: int
    created_at: datetime
    model: Optional[str] = None
    due_date: Optional[datetime] = None
    is_archived: bool
    archived_at: Optional[datetime] = None

    class Config:
        from_attributes = True


class WorkOrderUpdate(BaseModel):
    model: Optional[str] = None
    due_date: Optional[datetime] = None
    notes: Optional[str] = None


class WorkOrderArchive(BaseModel):
    is_archived: bool
