"""
Script to assign admins to clubs

Usage: python3 assign_admin_to_club.py <club_id> <admin_id>
Example: python3 assign_admin_to_club.py 1 1
"""
import sys
from app.db.session import SessionLocal
from app.models import User, Club

def assign_admin_to_club(club_id: int, admin_id: int):
    db = SessionLocal()
    try:
        # Get club
        club = db.query(Club).filter(Club.id == club_id).first()
        if not club:
            print(f"❌ Club with ID {club_id} not found")
            return False
        
        # Get admin
        admin = db.query(User).filter(User.id == admin_id, User.role == 'COMPANY_EMPLOYEE').first()
        if not admin:
            print(f"❌ Admin with ID {admin_id} not found")
            return False
        
        # Assign
        club.admin_id = admin_id
        db.commit()
        
        print(f"✅ Assigned {admin.email} to manage club '{club.name}'")
        return True
    finally:
        db.close()

if __name__ == "__main__":
    if len(sys.argv) != 3:
        print("Usage: python3 assign_admin_to_club.py <club_id> <admin_id>")
        print("\nCurrent clubs and admins:")
        
        db = SessionLocal()
        print("\n=== CLUBS ===")
        clubs = db.query(Club).all()
        for club in clubs:
            admin_email = "None"
            if club.admin_id:
                admin = db.query(User).filter(User.id == club.admin_id).first()
                if admin:
                    admin_email = admin.email
            print(f"  ID: {club.id}, Name: {club.name}, Admin: {admin_email}")
        
        print("\n=== ADMINS ===")
        admins = db.query(User).filter(User.role == 'COMPANY_EMPLOYEE').all()
        for admin in admins:
            print(f"  ID: {admin.id}, Email: {admin.email}")
        db.close()
        sys.exit(1)
    
    club_id = int(sys.argv[1])
    admin_id = int(sys.argv[2])
    assign_admin_to_club(club_id, admin_id)
